#ifndef __C4DBASEDRAW_H
#define __C4DBASEDRAW_H

#include "ge_matrix.h"
#include "c4d_baselist.h"
#include "c4d_basecontainer.h"

class BaseDrawHelp
{
	private:
		BaseDrawHelp(void);
	public:
		BaseDocument	*GetDocument(void) { return C4DOS.Br->BbGetDocument(this); }
		BaseTag				*GetActiveTag(void) { return C4DOS.Br->BbGetActiveTag(this); }
		Matrix				GetMg(void) { return C4DOS.Br->BbGetMg(this); }
		BaseContainer	GetDisplay(void) { BaseContainer bc; C4DOS.Br->BbGetDisplay(this,&bc); return bc; }
};

#define SAFEFRAME_NONE				0
#define SAFEFRAME_VERTICAL		1
#define SAFEFRAME_HORIZONTAL	2

class BaseView : public BaseList2D
{
	private:
		BaseView(void);
	public:
		void GetFrame(LONG *cl, LONG *ct, LONG *cr, LONG *cb);
		void GetSafeFrame(LONG *from, LONG *to, LONG *horizontal);
		void GetParameter(Vector *offset, Vector *scale, Vector *scale_z);
		Matrix GetMg(void) { return C4DOS.Bv->GetMg(this); }
		Matrix GetMi(void) { return C4DOS.Bv->GetMi(this); }
		LONG GetProjection(void) { return C4DOS.Bv->GetProjection(this); }
		Bool TestPoint(Real x, Real y) { return C4DOS.Bv->TestPoint(this,x,y); }
		Bool TestPointZ(const Vector &p) { return C4DOS.Bv->TestPointZ(this,p); }
		Bool TestClipping3D(const Vector &mp, const Vector &rad, const Matrix &mg, Bool *clip2d, Bool *clipz);
		Bool ClipLine2D(Vector *p1, Vector *p2) { return C4DOS.Bv->ClipLine2D(this,p1,p2); }
		Bool ClipLineZ(Vector *p1, Vector *p2) { return C4DOS.Bv->ClipLineZ(this,p1,p2); }
		Vector WS(const Vector &p) { return C4DOS.Bv->WS(this,p); }
		Vector SW(const Vector &p) { return C4DOS.Bv->SW(this,p); }
		Vector SW(Real x, Real y, const Vector &wp) { return C4DOS.Bv->SW_R(this,x,y,wp); }
		Vector WC(const Vector &p) { return C4DOS.Bv->WC(this,p); }
		Vector CW(const Vector &p) { return C4DOS.Bv->CW(this,p); }
		Vector SC(const Vector &p) { return C4DOS.Bv->SC(this,p); }
		Vector CS(const Vector &p, Bool z_inverse) { return C4DOS.Bv->CS(this,p,z_inverse); }
		Vector WC_V(const Vector &v) { return C4DOS.Bv->WC_V(this,v); }
		Vector CW_V(const Vector &v) { return C4DOS.Bv->CW_V(this,v); }
		Bool BackfaceCulling(const Vector &n, const Vector &p) { return C4DOS.Bv->BackfaceCulling(this,n,p); }
		Bool ZSensitive(void) { return C4DOS.Bv->ZSensitive(this); }
};

class BaseDraw : public BaseView
{
	private:
		BaseDraw(void);
	public:
		Bool       HasCameraLink(void) { return C4DOS.Br->HasCameraLink(this); }
		void       SetSceneCamera(BaseObject *op)  { C4DOS.Br->SetSceneCamera(this,op); }
		BaseObject *GetSceneCamera(BaseDocument *doc)  { return C4DOS.Br->GetSceneCamera(this,doc); }
		BaseObject *GetEditorCamera(void)  { return C4DOS.Br->GetEditorCamera(this); }

		Vector GetObjectColor(BaseDrawHelp *bh, BaseObject *op)  { return C4DOS.Br->GetObjectColor(this,op,bh); }
		Vector CheckColor(const Vector &col)  { return C4DOS.Br->CheckColor(this,col); }
		
		Bool ZBufAvailable(void)  { return C4DOS.Br->ZBufAvailable(this); }
		
		void SetTransparency(LONG trans)  { C4DOS.Br->SetTransparency(this,trans); }
		LONG GetTransparency(void)  { return C4DOS.Br->GetTransparency(this); }
		
		Bool PointInRange(const Vector &p, LONG x, LONG y)  { return C4DOS.Br->PointInRange(this,p,x,y); }
		void SetPen(const Vector &col)  { C4DOS.Br->SetPen(this,col); }
		Real SimpleShade(const Vector &p, const Vector &n)  { return C4DOS.Br->SimpleShade(this,p,n); }
		
		void Point2D(const Vector &p)  { C4DOS.Br->Point2D(this,p); }
		void Line2D(const Vector &p1, const Vector &p2)  { C4DOS.Br->Line2D(this,p1,p2); }
		void Handle2D(const Vector &p, LONG type=HANDLE_SMALL) { C4DOS.Br->Handle2D(this,p,type); }
		void Circle2D(LONG mx, LONG my, Real rad) { C4DOS.Br->Circle2D(this,mx,my,rad); }
		void LineCS(const Vector &p1, const Vector &p2, Bool clip2d, Bool clipz,Bool offset=FALSE) { C4DOS.Br->LineCS(this,p1,p2,clip2d,clipz,offset); }
		void Point3D(const Vector &p) { C4DOS.Br->Point3D(this,p); }
		void Line3D(const Vector &p1, const Vector &p2) { C4DOS.Br->Line3D(this,p1,p2); }
		void Handle3D(const Vector &p, LONG type) { C4DOS.Br->Handle3D(this,p,type); }
		void Circle3D(const Matrix &m) { C4DOS.Br->Circle3D(this,m); }
		void Box3D(const Matrix &m, Real size, const Vector &col) { C4DOS.Br->Box3D(this,m,size,col); }
		void Polygon3D(Vector *p, Vector *f, Bool quad) { C4DOS.Br->Polygon3D(this,p,f,quad); }
		void PolygonObject(BaseDrawHelp *bh, PolygonObject *op, LONG flags) { C4DOS.Br->PolygonObject(this,bh,op,flags); }
};

#endif
